/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.formatter;

import beaver.Parser;
import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.parsing.CompositeParser;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.formatter.HTMLFormatterContext;
import com.aptana.editor.html.formatter.HTMLFormatterNodeBuilder;
import com.aptana.editor.html.formatter.HTMLFormatterNodeRewriter;
import com.aptana.editor.html.formatter.HTMLFormatterPlugin;
import com.aptana.editor.html.parsing.HTMLParseState;
import com.aptana.editor.html.parsing.HTMLParser;
import com.aptana.formatter.AbstractScriptFormatter;
import com.aptana.formatter.FormatterDocument;
import com.aptana.formatter.FormatterIndentDetector;
import com.aptana.formatter.FormatterUtils;
import com.aptana.formatter.FormatterWriter;
import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.IFormatterWriter;
import com.aptana.formatter.IScriptFormatter;
import com.aptana.formatter.ScriptFormatterManager;
import com.aptana.formatter.epl.FormatterPlugin;
import com.aptana.formatter.nodes.IFormatterContainerNode;
import com.aptana.formatter.ui.FormatterException;
import com.aptana.formatter.ui.FormatterMessages;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.IParser;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.ui.util.StatusLineMessageTimerManager;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLFormatter
extends AbstractScriptFormatter
implements IScriptFormatter {
    protected static final String[] BLANK_LINES = new String[]{"html.formatter.line.after.element", "html.formatter.line.before.non.html", "html.formatter.line.after.non.html", "html.formatter.line.preserve"};

    protected HTMLFormatter(String lineSeparator, Map<String, String> preferences, String mainContentType) {
        super(preferences, mainContentType, lineSeparator);
    }

    public int detectIndentationLevel(IDocument document, int offset, boolean isSelection, IFormattingContext formattingContext) {
        String source = document.get();
        int indent = 0;
        try {
            HTMLParseState parseState = new HTMLParseState(source);
            IParseRootNode parseResult = ParserPoolFactory.parse((String)this.getMainContentType(), (IParseState)parseState).getRootNode();
            if (parseResult != null) {
                HTMLFormatterNodeBuilder builder = new HTMLFormatterNodeBuilder();
                FormatterDocument formatterDocument = this.createFormatterDocument(source);
                IFormatterContainerNode root = builder.build((IParseNode)parseResult, formatterDocument);
                new HTMLFormatterNodeRewriter().rewrite(root);
                HTMLFormatterContext context = new HTMLFormatterContext(0);
                FormatterIndentDetector detector = new FormatterIndentDetector(offset);
                try {
                    root.accept((IFormatterContext)context, (IFormatterWriter)detector);
                    return detector.getLevel();
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable t) {
            return super.detectIndentationLevel(document, offset);
        }
        return indent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TextEdit format(String source, int offset, int length, int indentationLevel, boolean isSelection, IFormattingContext context, String indentSufix) throws FormatterException {
        if (!ScriptFormatterManager.hasFormatterFor((String)this.getMainContentType())) {
            throw new FormatterException(FormatterMessages.Formatter_contentErrorMessage);
        }
        String input = source.substring(offset, offset + length);
        IParser parser = this.checkoutParser();
        String mainContentType = this.getMainContentType();
        if (!(parser instanceof HTMLParser) && !(parser instanceof CompositeParser)) {
            this.checkinParser(parser, mainContentType);
            mainContentType = "com.aptana.contenttype.html";
            parser = this.checkoutParser(mainContentType);
        }
        try {
            HTMLParseState parseState = new HTMLParseState(input);
            IParseRootNode parseResult = null;
            try {
                try {
                    parseResult = parser.parse((IParseState)parseState).getRootNode();
                }
                catch (Exception e) {
                    StatusLineMessageTimerManager.setErrorMessage((String)FormatterMessages.Formatter_formatterErrorStatus, (long)3000L, (boolean)true);
                    IdeLog.logError((Plugin)HTMLFormatterPlugin.getDefault(), (Throwable)e, (String)"com.aptana.formatter.epl/debug");
                    TextEdit textEdit = this.indent(source, input, offset, length, indentationLevel);
                    this.checkinParser(parser, mainContentType);
                    return textEdit;
                }
            }
            finally {
                this.checkinParser(parser, mainContentType);
            }
            if (parseResult == null) return null;
            String output = this.format(input, (IParseNode)parseResult, indentationLevel, isSelection);
            if (output == null) return null;
            if (input.equals(output)) return new MultiTextEdit();
            if (this.equalsIgnoreWhitespaces(input, output)) {
                return new ReplaceEdit(offset, length, output);
            }
            this.logError(input, output);
            return null;
        }
        catch (Parser.Exception e) {
            StatusLineMessageTimerManager.setErrorMessage((String)NLS.bind((String)FormatterMessages.Formatter_formatterParsingErrorStatus, (Object)e.getMessage()), (long)3000L, (boolean)true);
            if (!FormatterPlugin.getDefault().isDebugging()) return null;
            IdeLog.logError((Plugin)HTMLFormatterPlugin.getDefault(), (Throwable)e, (String)"com.aptana.formatter.epl/debug");
            return null;
        }
        catch (Throwable t) {
            StatusLineMessageTimerManager.setErrorMessage((String)FormatterMessages.Formatter_formatterErrorStatus, (long)3000L, (boolean)true);
            IdeLog.logError((Plugin)HTMLFormatterPlugin.getDefault(), (Throwable)t, (String)"com.aptana.formatter.epl/debug");
        }
        return null;
    }

    public int getIndentSize() {
        return this.getInt("html.formatter.formatter.indentation.size", 1);
    }

    public String getIndentType() {
        return this.getString("html.formatter.formatter.tabulation.char");
    }

    public int getTabSize() {
        return this.getInt("html.formatter.formatter.tabulation.size", this.getEditorSpecificTabWidth());
    }

    public int getEditorSpecificTabWidth() {
        return EditorUtil.getSpaceIndentSize((String)HTMLPlugin.getDefault().getBundle().getSymbolicName());
    }

    public boolean isEditorInsertSpacesForTabs() {
        return FormatterUtils.isInsertSpacesForTabs((IPreferenceStore)HTMLPlugin.getDefault().getPreferenceStore());
    }

    private String format(String input, IParseNode parseResult, int indentationLevel, boolean isSelection) throws Exception {
        int spacesCount = -1;
        if (isSelection) {
            spacesCount = HTMLFormatter.countLeftWhitespaceChars((String)input);
        }
        FormatterDocument document = this.createFormatterDocument(input);
        FormatterWriter writer = new FormatterWriter((IFormatterDocument)document, this.lineSeparator, this.createIndentGenerator());
        HTMLFormatterNodeBuilder builder = new HTMLFormatterNodeBuilder(writer);
        IFormatterContainerNode root = builder.build(parseResult, document);
        new HTMLFormatterNodeRewriter().rewrite(root);
        HTMLFormatterContext context = new HTMLFormatterContext(indentationLevel);
        writer.setWrapLength(this.getInt("html.formatter.wrap.comments.length"));
        writer.setLinesPreserve(this.getInt("html.formatter.line.preserve"));
        root.accept((IFormatterContext)context, (IFormatterWriter)writer);
        writer.flush((IFormatterContext)context);
        String output = writer.getOutput();
        List offOnRegions = builder.getOffOnRegions();
        if (offOnRegions != null && !offOnRegions.isEmpty()) {
            List outputOnOffRegions = this.getOutputOnOffRegions(this.getString("html.formatter.formatter.off"), this.getString("html.formatter.formatter.on"), (IParseState)new HTMLParseState(output));
            output = FormatterUtils.applyOffOnRegions((String)input, (String)output, (List)offOnRegions, (List)outputOnOffRegions);
        }
        if (isSelection) {
            output = HTMLFormatter.leftTrim((String)output, (int)spacesCount);
        }
        return output;
    }

    private FormatterDocument createFormatterDocument(String input) {
        FormatterDocument document = new FormatterDocument(input);
        document.setInt("html.formatter.formatter.tabulation.size", this.getInt("html.formatter.formatter.tabulation.size"));
        document.setBoolean("html.formatter.wrap.comments", this.getBoolean("html.formatter.wrap.comments"));
        document.setBoolean("html.formatter.comments.in.separate.lines", this.getBoolean("html.formatter.comments.in.separate.lines"));
        document.setSet("html.formatter.indent.excluded", this.getSet("html.formatter.indent.excluded", "!"));
        document.setSet("html.formatter.newline.excluded", this.getSet("html.formatter.newline.excluded", "!"));
        document.setBoolean("html.formatter.newline.exclusion.in.empty.tag", this.getBoolean("html.formatter.newline.exclusion.in.empty.tag"));
        document.setBoolean("html.formatter.spaces.trim", this.getBoolean("html.formatter.spaces.trim"));
        document.setBoolean("html.formatter.formatter.on.off.enabled", this.getBoolean("html.formatter.formatter.on.off.enabled"));
        document.setString("html.formatter.formatter.on", this.getString("html.formatter.formatter.on"));
        document.setString("html.formatter.formatter.off", this.getString("html.formatter.formatter.off"));
        int i = 0;
        while (i < BLANK_LINES.length) {
            document.setInt(BLANK_LINES[i], this.getInt(BLANK_LINES[i]));
            ++i;
        }
        return document;
    }
}

